ORCA/M Asm65816 2.1.0

0001 B4A4                       TITLE 'Miscellaneous Debug0 Routines'
0002 B4A4
0003 B4A4              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 B4A4              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 6:30:4 PM
0005 B4A4
0006 B4A4              ******************************************************
0007 B4A4              *                                                    *
0008 B4A4              *             Miscellaneous Debug0 Routines          *
0009 B4A4              *                                                    *
0010 B4A4              *                    by                              *
0011 B4A4              *               Fern Bachman     1985-1987           *
0012 B4A4              *               Joe Bo           1987-1989           *
0013 B4A4              *                                                    *
0014 B4A4              *       Copyright Apple Computer, Inc. 1985-1989     *
0015 B4A4              *                All Rights Reserved.                *
0016 B4A4              *                                                    *
0017 B4A4              ******************************************************
0018 B4A4
0019 B4A4              * ZMEMORY zaps memory with the contents of A4L.
0020 B4A4              *
0021 B4A4              * User entry format is   zz < bb1/addr1.bb2/addr2Z
0022 B4A4              *
0023 B4A4              * A4L contains zap data on entry to here
0024 B4A4              * A1L/A1H contains starting address to zap
0025 B4A4              * A2L/A2H contains last address to zap
0026 B4A4              * EXTENDBNKS contains bb1 if specified else is zero, see the
0027 B4A4              *  conditions in XMOVE1 !!!
0028 B4A4              * A4L/A4H is set to starting address+1 to zap
0029 B4A4
0030 B4A4              ZMEMORY  EQU   *                        ;Zap memory
0031 B4A4 AF 3E 01 E1           LDA   >BANKS                   ;Make source bank = destination bank
0032 B4A8 8F 3F 01 E1           STA   >BANKD                   ;
0033 B4AC A4 42                 LDY   A4L                      ;Get zap character
0034 B4AE C2 30                 REP   #$30                     ;16 bit land please
0035 B4B0 A5 3C                 LDA   A1L                      ;Make destination address
0036 B4B2 85 42                 STA   A4L                      ; the save as source address.
0037 B4B4 C6 3E                 DEC   A2L                      ;Fix pointer
0038 B4B6 E2 30                 SEP   #$30                     ;Back to 8 bit land
0039 B4B8 98                    TYA                            ;Save zap char as 1 byte in destination
0040 B4B9 A2 42                 LDX   #A4L                     ;Needed for STORBYTE
0041 B4BB 20 EC B7              JSR   STORBYTE                 ;
0042 B4BE C2 30                 REP   #$30                     ;Off to 16 bit land
0043 B4C0 E6 42                 INC   A4L                      ;Create new destination address
0044 B4C2 E2 30                 SEP   #$30                     ;Back to 16 bit land
0045 B4C4
0046 B4C4              * Fall into to XMOVE1 to do actual zap and exit.
0047 B4C4
0048 B4C4
0049 B4C4              * Move a block of memory
0050 B4C4              *
0051 B4C4              * User entry format: aa/addr0 < bb1/addr1.bb2/addr2M                   
0052 B4C4              *
0053 B4C4              *  if bb2 < bb1 then invalid and move one byte  
0054 B4C4              *  if bb2 is not specified then assume bb2 = bb1 AND
0055 B4C4              *   if addr2 < addr1 then illegal and move one byte
0056 B4C4              *  if bb2 > bb1 then valid and it is crossing bank 
0057 B4C4
0058 B4C4              XMOVE1   EQU   *
0059 B4C4 AD 68 C0              LDA   STATEREG                 ;Save memory state
0060 B4C7 CD 83 C0              CMP   LCBANK2                  ;Write enable language card
0061 B4CA CD 83 C0              CMP   LCBANK2                  ;Write enable language card
0062 B4CD 48                    PHA                            ;
0063 B4CE 8B                    PHB                            ;
0064 B4CF 29 F2                 AND   #$F2                     ;Set slot LCRAM/BANK1/SLOTROMCXROM to read
0065 B4D1 48                    PHA                            ;Save for later
0066 B4D2 AF 2F 01 E1           LDA   >LVAL                    ;Check which LC bank to enable
0067 B4D6 0A                    ASL   A                        ;Bit 2=1 for bank1 else leave bank 0
0068 B4D7 0A                    ASL   A                        ;
0069 B4D8 03 01                 ORA   1,S                      ;Or in status byte on stack
0070 B4DA 8D 68 C0              STA   STATEREG                 ;
0071 B4DD 68                    PLA                            ;Clean up stack
0072 B4DE              *
0073 B4DE C2 20                 REP   #$20                     ;16/8 bit m/x
0074 B4E0                       LONGA ON
0075 B4E0                       LONGI OFF
0076 B4E0 8B                    PHB                            ;Save data bank
0077 B4E1 20 82 F8              JSR   DBTOE1                   ;Change to $e1 bank
0078 B4E4 A2 00                 LDX   #$0                      ;    
0079 B4E6 DA                    PHX                            ;Make hgh byte of hgh word src ptr = 0
0080 B4E7 AC 3E 01              LDY   |BANKS                   ;Get low byte of high word source pointer'
0081 B4EA 5A                    PHY                            ;
0082 B4EB A5 3C                 LDA   A1L                      ;Get 16 bit low word of source address
0083 B4ED 48                    PHA                            ;
0084 B4EE DA                    PHX                            ;Make hgh byte of hgh word dest ptr = 0
0085 B4EF AC 3F 01              LDY   |BANKD                   ;Get low byte of high word dest pointer
0086 B4F2 5A                    PHY                            ;
0087 B4F3 A5 42                 LDA   A4L                      ;Get 16 bit low word of dest address
0088 B4F5 48                    PHA                            ;
0089 B4F6
0090 B4F6              @1       EQU   *
0091 B4F6 AD 3E 01              LDA   |BANKS                   ;Get the source address starting bank
0092 B4F9 29 FF 00              AND   #$00FF                   ;Mask off high word
0093 B4FC 48                    PHA                            ;Save on stack for later
0094 B4FD AA                    TAX   
0095 B4FE EC A7 01              CPX   |HIGHBANK                ;CHK for crossing bank
0096 B501 F0 0B                 BEQ   @0                       ;Bra if no
0097 B503 90 0F                 BCC   @3                       ;Bra if yes
0098 B505              ;PHX 
0099 B505              ;LDX :EXTENDBNKS ;Not cross bank, but could be user
0100 B505              ;BNE @5.1 ; doesn't specify ending bank
0101 B505              ;PLX  ;If not specify then make end = start bank
0102 B505              ;STX :EXTENDBNKS 
0103 B505              ;BRA @0 ;Continue on
0104 B505              ;@5.1 EQU *
0105 B505              ;PLX ;
0106 B505 8E A7 01              STX   |HIGHBANK                ;
0107 B508              @5       EQU   *
0108 B508 A9 01 00              LDA   #$0001                   ;If usr do specify end bank, but end bank
0109 B50B 38                    SEC                            ; less than start bank, illegal !!
0110 B50C 80 0C                 BRA   @6                       ;Just move one byte
0111 B50E              @0       EQU   *
0112 B50E A5 3E                 LDA   A2L                      ;If same bank, how about start/end address
0113 B510 C5 3C                 CMP   A1L                      ;If start > end, fine
0114 B512 90 F4                 BCC   @5                       ;Else just move one byte
0115 B514              @3       EQU   *
0116 B514 38                    SEC                            ;Set 'c'=1 for sbc
0117 B515 A5 3E                 LDA   A2L                      ;Get low word of ending address
0118 B517 E5 3C                 SBC   A1L                      ;Low word count, ending - starting
0119 B519 1A                    INC   A                        ;Actual transfer count to MEMMOVER
0120 B51A              @6       EQU   *
0121 B51A 85 3E                 STA   A2L                      ;Temp store 
0122 B51C D0 03                 BNE   @2                       ;Is it already at $ffff ?  
0123 B51E EE A7 01              INC   |HIGHBANK                ;If at $ffff, adjust bank byte by 1 first
0124 B521              @2       EQU   *
0125 B521 AD A7 01              LDA   |HIGHBANK                ;Ending bank of source address
0126 B524 29 FF 00              AND   #$00FF                   ;Mask off unwanted
0127 B527 E3 01                 SBC   1,S                      ;Calculate for high word of transfer count
0128 B529 29 FF 00              AND   #$00FF                   ;
0129 B52C 83 01                 STA   1,S                      ;Store result on stack
0130 B52E A5 3E                 LDA   A2L                      ;Restore low word of count
0131 B530 48                    PHA                            ;Store to stack
0132 B531
0133 B531 A9 05 08              LDA   #$0805                   ;Command word for move_info, use movesincdinc
0134 B534 48                    PHA                            ;
0135 B535 C2 30                 REP   #$30                     ;Set to 16 bit 'x' also
0136 B537 22 61 B5 FF           JSL   >MEMMOVER                ;Jmp to do the move
0137 B53B AB                    PLB                            ;Restore data bank
0138 B53C E2 30                 SEP   #$30                     ;8 bit land in the monitor
0139 B53E 4C 30 B8              JMP   MEMEXIT
0140 B541
0141 B541
0142 B541                       EJECT 
0143 B541
0144 B541              MOVETABLE EQU   *
0145 B541 07 B6                 DC W:MSCONDCON                 ;0 source constant-destination constant
0146 B543 18 B6                 DC W:MSINCDCON                 ;1 source incs - destination constant
0147 B545 35 B6                 DC W:MSDECDCON                 ;2 source decs - destination constant
0148 B547 B4 B5                 DC W:MABORTMOVE                ;3 illegal move sequence requested
0149 B549 56 B6                 DC W:MSCONDINC                 ;4 source constant - destination incs
0150 B54B B4 B5                 DC W:MABORTMOVE                ;5 src/dest incs should never gets here
0151 B54D 73 B6                 DC W:MSDECDINC                 ;6 source decs - destination incs
0152 B54F B4 B5                 DC W:MABORTMOVE                ;7 illegal move sequence requested
0153 B551 A3 B6                 DC W:MSCONDDEC                 ;8 source constant - destination decs
0154 B553 C4 B6                 DC W:MSINCDDEC                 ;9 source incs - destination decs
0155 B555 B4 B5                 DC W:MABORTMOVE                ;a src/dest decs should never gets here
0156 B557 B4 B5                 DC W:MABORTMOVE                ;b illegal move sequence requested
0157 B559 B4 B5                 DC W:MABORTMOVE                ;c "
0158 B55B B4 B5                 DC W:MABORTMOVE                ;d "
0159 B55D B4 B5                 DC W:MABORTMOVE                ;e "
0160 B55F B4 B5                 DC W:MABORTMOVE                ;f "
0161 B561
0162 B561
0163 B561              ;
0164 B561              ; move_info revision history
0165 B561              ;
0166 B561              ; the general move routine (m_sinc_dinc) algorithm in this program is based
0167 B561              ; on the one used by the memory manager. it has been updated for gs/os
0168 B561              ; purposes and in hopes that new hardware will take over this functionality                
0169 B561              ; in the future.
0170 B561              ;
0171 B561              ; memory manager move routine is by rich williams in original iigs rom.
0172 B561              ; later modified for prodos16 by jim jatczynski.
0173 B561              ;
0174 B561              ; 1/04/88 fab 1st release as move_info routine by fern bachman jr.
0175 B561              ; 1/18/88 fab msdecdcon / msconddec needed cpy #$ffff in loop to test for
0176 B561              ; falling through an address into the next lower bank.
0177 B561              ; msincddec / msdecdinc fixed counter calculation in to
0178 B561              ; include count+1 when doing 8 bit increment.
0179 B561              ; mscondinc changed inc <dest to inc <dest+2 for correct dest
0180 B561              ; bank increment
0181 B561              ; performance statistics table added
0182 B561              ;
0183 B561              ; installed to monitor by Joe Bo         3/88
0184 B561              ;
0185 B561              ;===============================================================================
0186 B561              ;
0187 B561              ;===============================================================================
0188 B561              ;
0189 B561              ; performance statistics table
0190 B561              ;
0191 B561              ; # subroutine time/byte time/$10000 bytes
0192 B561              ;-------------------------------------------------------
0193 B561              ; 0 mscondcon 7.36 usec 485.8 msec
0194 B561              ; 1 msincdcon 9.30 usec 615.6 msec
0195 B561              ; 2 msdecdcon 10.48 usec 691.9 msec
0196 B561              ; 4 mscondinc 9.30 usec 615.6 msec
0197 B561              ; 5 msincdinc  2.78 usec 180.7 msec
0198 B561              ; 6 msdecdinc 18.20 usec 1209.0 msec
0199 B561              ; 8 msconddec 10.48 usec 691.9 msec
0200 B561              ; 9 msincddec 18.20 usec 1209.0 msec
0201 B561              ; a msdecddec  2.78 usec 180.8 msec
0202 B561              ;
0203 B561              ;===============================================================================
0204 B561              ;
0205 B561                       EJECT 
0206 B561              ;
0207 B561              ;===============================================================================
0208 B561              ; move_info
0209 B561              ;
0210 B561              ; Moves a block of data from a source location to a destination location.
0211 B561              ;
0212 B561              ; Calling sequence:
0213 B561              ; 1. Place machine in full native mode (e=0, m=0, x=0)
0214 B561              ;
0215 B561              ; 2. Push high order word of source pointer onto stack
0216 B561              ; 3. Push low order word of source pointer
0217 B561              ; 4. Push high order word of destination pointer
0218 B561              ; 5. Push low order word of destination pointer
0219 B561              ; 6. Push high order word of transfer count
0220 B561              ; 7. Push low order word of transfer count
0221 B561              ;
0222 B561              ; 8. Push command byte
0223 B561              ; _______________________________________________
0224 B561              ; |  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |
0225 B561              ; |15|14|13|12|11|10|09|08|07|06|05|04|03|02|01|00|
0226 B561              ; |__|__|__|__|__|__|__|__|__|__|__|__|__|__|__|__|
0227 B561              ;
0228 B561              ; bits 15/14 = reserved
0229 B561              ; bits 13/12/11 = move mode
0230 B561              ; = 000 =reserved
0231 B561              ; = 001 =block move
0232 B561              ; = 010-111 =reserved
0233 B561              ; bits 10/9/8/7 = reserved
0234 B561              ; bits 6/5/4 = reserved
0235 B561              ; bits 3/2 = destination incrementer
0236 B561              ; = 00 (+0) =constant destination
0237 B561              ; = 01 (+1) =increment destination by 1
0238 B561              ; = 10 (-1) =decrement destination by 1
0239 B561              ; = 11 =reserved
0240 B561              ; bits 1/0 = source incrementer
0241 B561              ; = 00 (+0) =constant source
0242 B561              ; = 01 (+1) =increment source by 1
0243 B561              ; = 10 (-1) =decrement source by 1
0244 B561              ; = 11 =reserved
0245 B561              ;
0246 B561              ; 9. jsl move_info
0247 B561              ;
0248 B561              ;
0249 B561                       EJECT 
0250 B561              ;
0251 B561              ; Stack on entry
0252 B561              ; _______________________________________
0253 B561              ; |                                       |
0254 B561              ; |- high word of source pointer          |
0255 B561              ; |_______________________________________| s+$10
0256 B561              ; |                                       |
0257 B561              ; |- low word of source pointer           |
0258 B561              ; |_______________________________________| s+$0e
0259 B561              ; |                                       |
0260 B561              ; |- high word of destination pointer     |
0261 B561              ; |_______________________________________| s+$0c
0262 B561              ; |                                       |
0263 B561              ; |- low word of destination pointer      |
0264 B561              ; |_______________________________________| s+$0a
0265 B561              ; |                                       |
0266 B561              ; |- high word of transfer count          |
0267 B561              ; |_______________________________________| s+$08
0268 B561              ; |                                       |
0269 B561              ; |- low word of transfer count           |
0270 B561              ; |_______________________________________| s+$06
0271 B561              ; |                                       |
0272 B561              ; |- command word                         |
0273 B561              ; |_______________________________________| s+$04
0274 B561              ; |                                       |
0275 B561              ; |-                                      |
0276 B561              ; | return address                        |
0277 B561              ; |-                                      |
0278 B561              ; |_______________________________________| s+$01
0279 B561              ;
0280 B561              ;
0281 B561              ; Outputs: if no error then
0282 B561              ; a= $0000
0283 B561              ; c= 0
0284 B561              ; if error then
0285 B561              ; a= error code
0286 B561              ; c= 1
0287 B561              ; data bank and direct register are preserved
0288 B561              ; a= error code
0289 B561              ; x,y = scrambled
0290 B561              ;
0291 B561              ; Notes: The high byte of source, dest, and Count must be zero
0292 B561              ; The source and destination blocks must not overlap
0293 B561              ; This routine executes self modifying code on the stack
0294 B561              ; and therefore is romable and reentrant
0295 B561              ;===============================================================================
0296 B561              ;
0297 B561              MMOVEEQU EQU   *
0298 B561              ;
0299 B561              ; zero page locations used on stack
0300 B561              ;
0301 B561              MSOURCE  EQU   $16                      ; 4-byte source address
0302 B561              MDEST    EQU   $12                      ; 4-byte destination address
0303 B561              MCOUNT   EQU   $0E                      ; 4-byte transfer count
0304 B561              MMOVECOMMAND EQU   $0C                  ; 2-byte command word
0305 B561              MRETURNMOVE EQU   $09                   ; 3-byte return address
0306 B561              MTEMPCOUNT EQU   $07                    ; 2-byte temporary transfer count
0307 B561              MDOMOVE  EQU   $03                      ; 4-byte mvn 0000 / rtl instructions
0308 B561              MSTACKUSED EQU   $14                    ; number of bytes on stack used
0309 B561
0310 B561                                                      ; SEG $ff
0311 B561              MEMMOVER EQU   *
0312 B561                                                      ; SEG $00
0313 B561
0314 B561                       LONGA ON
0315 B561                       LONGI ON
0316 B561 48                    PHA                            ; push two bytes on stack for tempcount
0317 B562 F4 00 6B              PEA   $6b00                    ;push an rtl instruction onto stack
0318 B565
0319 B565              ; note the a place holder of $00 was left on the stack when the rtl instrucion
0320 B565              ; was placed on the stack. that byte will become the high byte of the operand
0321 B565              ; for the mvn instruction about to be pushed onto the stack
0322 B565              ;
0323 B565              ; now put an mvn xxxx instruction on the stack (operand is modified later)
0324 B565
0325 B565 F4 54 00              PEA   $0054                    ;mvn and low byte of mvn operand
0326 B568 0B                    PHD                            ; save user's direct page pointer 'd'
0327 B569 3B                    TSC                            ; make direct page correspond to stack
0328 B56A 5B                    TCD   
0329 B56B
0330 B56B              ; zero page is now on stack here
0331 B56B              ;
0332 B56B              ; zero page after pha, phd, push of 'mvn xxxx, rtl' tsc and tcd
0333 B56B              ; _______________________________________
0334 B56B              ; |                                       |
0335 B56B              ; |- high word of source pointer          |
0336 B56B              ; |_______________________________________| $18
0337 B56B              ; |                                       |
0338 B56B              ; |- low word of source pointer           |      
0339 B56B              ; |_______________________________________| $16
0340 B56B              ; |                                       |
0341 B56B              ; |- high word of destination pointer     |
0342 B56B              ; |_______________________________________| $14
0343 B56B              ; |                                       |
0344 B56B              ; |- low word of destination pointer      |
0345 B56B              ; |_______________________________________| $12
0346 B56B              ; |                                       |
0347 B56B              ; |- high word of transfer count          |
0348 B56B              ; |_______________________________________| $10
0349 B56B              ; |                                       |
0350 B56B              ; |- low word of transfer count           |
0351 B56B              ; |_______________________________________| $0e
0352 B56B              ; |                                       |
0353 B56B              ; |- command word                         |
0354 B56B              ; |_______________________________________| $0c
0355 B56B              ; |                                       |
0356 B56B              ; |-                                      |
0357 B56B              ; | return address                        |
0358 B56B              ; |-                                      |
0359 B56B              ; |_______________________________________| $09
0360 B56B              ; |                                       |
0361 B56B              ; |- temp count word                      |
0362 B56B              ; |_______________________________________| $07
0363 B56B              ; | rtl                                   |
0364 B56B              ; |_______________________________________| $06
0365 B56B              ; |                                       |
0366 B56B              ; |-                                      |
0367 B56B              ; | domove mvn 0000 ;(modified code)      |
0368 B56B              ; |-                                      |
0369 B56B              ; |_______________________________________| $03
0370 B56B              ; |                                       |
0371 B56B              ; |- user's direct page                   |
0372 B56B              ; |_______________________________________| $01
0373 B56B              ;
0374 B56B              ;
0375 B56B              ; stack moves down when phb info, rtl's info, and rts are placed on stack
0376 B56B              ; _______________________________________
0377 B56B              ; | user's data bank register             |
0378 B56B              ; |_______________________________________|
0379 B56B              ; | rts back from jsr domvxonstack        |
0380 B56B              ; |-                                      |
0381 B56B              ; |_______________________________________|
0382 B56B              ; |                                       |
0383 B56B              ; |-                                      |
0384 B56B              ; | rtl which points to continuation addr |
0385 B56B              ; |-                                      |
0386 B56B              ; |_______________________________________|
0387 B56B              ; |                                       |
0388 B56B              ; |-                                      |
0389 B56B              ; | rtl which points to domove            |
0390 B56B              ; |-                                      |
0391 B56B              ; |_______________________________________|
0392 B56B              ;
0393 B56B
0394 B56B 8B                    PHB                            ; save dbr on stack (mvn trashes it)
0395 B56C A5 18                 LDA   msource+2                ;is high byte of dest/src/count = 0 ??
0396 B56E 05 14                 ORA   mdest+2
0397 B570 05 10                 ORA   mcount+2
0398 B572 29 00 FF              AND   #$ff00
0399 B575 D0 3D                 BNE   mabortmove               ;not = then a high byte <>=0 was found
0400 B577
0401 B577              ; if the number of bytes to move equals zero we are done before we started
0402 B577
0403 B577 A5 0E                 LDA   mcount
0404 B579 05 10                 ORA   mcount+2
0405 B57B F0 34                 BEQ   mmovefinished            ;finished before we started (ha! ha!)
0406 B57D
0407 B57D              ; to speed up the most common move routine we will check for it now and
0408 B57D              ; not let it go through the normal move dispatcher
0409 B57D
0410 B57D A5 0C                 LDA   mmovecommand             ;test if valid or not
0411 B57F C9 05 08              CMP   #movesincdinc            ;test for most common mode first
0412 B582 F0 4E                 BEQ   msincdinc                ;= then do it quickly
0413 B584
0414 B584              ; to speed up the second most common move routine we will check for it now and
0415 B584              ; not let it go through the normal move dispatcher
0416 B584
0417 B584 C9 0A 08              CMP   #movesdecddec            ;test for the 2nd most common mode first
0418 B587 D0 03                 BNE   moveinfo4
0419 B589 4C F4 B6              JMP   msdecddec                ;= then do it quickly
0420 B58C
0421 B58C              ; the next 'bit' instruction uses a mask to test for invalid commands and
0422 B58C              ; invalid options. this mask (found in equates/common.equ) must change as
0423 B58C              ; other commands become valid.
0424 B58C              ;
0425 B58C              MOVEINFO4 EQU   *
0426 B58C 89 F0 F7              BIT   #movevaliditymask        ;reserved bits set?
0427 B58F D0 23                 BNE   mabortmove
0428 B591 89 00 08              BIT   #moveblkcmd              ;if moveblkcmd bit isn't set then error
0429 B594 F0 1E                 BEQ   mabortmove
0430 B596
0431 B596              ; if we fall to here then figure out which move to do
0432 B596
0433 B596 29 0F 00              AND   #$000f                   ;upper 3 nibbles are not important
0434 B599 0A                    ASL   a                        ;set up 'x' to get to rest of moves
0435 B59A AA                    TAX   
0436 B59B
0437 B59B              ; most of the move routines need this function so all routines will incur the
0438 B59B              ; overhead. this is better and shorter than making it a callable subroutine.
0439 B59B
0440 B59B              ; make count into 2's complement so we can increment to $00000000 instead of
0441 B59B              ; decrementing to $00000000 since it is faster to increment than decrement
0442 B59B              ; 32 bits worth of data (no compares needed).
0443 B59B
0444 B59B A5 0E                 LDA   mcount                   ;low word of count
0445 B59D 49 FF FF              EOR   #$ffff                   ;
0446 B5A0 A8                    TAY                            ;save for later
0447 B5A1 A5 10                 LDA   mcount+2                 ;high word of count
0448 B5A3 49 FF FF              EOR   #$ffff                   ;'a'=high word and 'y'=low word now
0449 B5A6
0450 B5A6 C8                    INY                            ;make 2's complement now
0451 B5A7 D0 01                 BNE   moveinfo8
0452 B5A9 1A                    INC   a
0453 B5AA
0454 B5AA              MOVEINFO8 EQU   *
0455 B5AA 84 0E                 STY   mcount                   ;leave on zero page
0456 B5AC 85 10                 STA   mcount+2                 ;leave on zero page
0457 B5AE
0458 B5AE              ; warning - code that gets jumped to from here assumes count is in 'y'
0459 B5AE
0460 B5AE 7C 41 B5              JMP   (movetable,x)            ;off to routine
0461 B5B1
0462 B5B1              ; common exit routine is here. all errors and move routines finish up here.
0463 B5B1
0464 B5B1              MMOVEFINISHED EQU   *                   ;no bytes left to move
0465 B5B1 18                    CLC                            ;indicate no error encountered
0466 B5B2 90 01                 BCC   NOmabortmove
0467 B5B4
0468 B5B4              MABORTMOVE EQU   *
0469 B5B4 38                    SEC                            ;indicate an error was encountered
0470 B5B5
0471 B5B5              NOMABORTMOVE EQU   *
0472 B5B5 C2 30                 REP   #$30                     ;must exit in full native mode
0473 B5B7
0474 B5B7 AB                    PLB                            ; restore dbr
0475 B5B8 A5 09                 LDA   mreturnmove              ; move return address past parameters
0476 B5BA 85 17                 STA   msource+1
0477 B5BC A5 0A                 LDA   mreturnmove+1            ; move return address past parameters
0478 B5BE 85 18                 STA   msource+2
0479 B5C0
0480 B5C0 2B                    PLD                            ; restore user's direct register
0481 B5C1
0482 B5C1 3B                    TSC                            ; set s to proper value
0483 B5C2 08                    PHP                            ;save 'c' around addition
0484 B5C3 18                    CLC   
0485 B5C4 69 14 00              ADC   #mstackused              ;number of bytes used on stack
0486 B5C7 28                    PLP                            ;restore correct exit 'c'
0487 B5C8 1B                    TCS                            ;fix up stack
0488 B5C9
0489 B5C9              ; Set 'a' correctly for exit based on 'c'
0490 B5C9
0491 B5C9 A9 00 00              LDA   #$0000                   ;assume no errors
0492 B5CC 90 03                 BCC   cleanexit                ;
0493 B5CE A9 FF FF              LDA   #parmrangeerr            ;it's an error if here
0494 B5D1
0495 B5D1              CLEANEXIT EQU   *
0496 B5D1 6B                    RTL   
0497 B5D2
0498 B5D2
0499 B5D2
0500 B5D2              MSINCDINC EQU   *                       ;5 source incs - destination incs
0501 B5D2
0502 B5D2              ; move with incrementing source address and incrementing destination address
0503 B5D2              ; get ready to do the standard move
0504 B5D2
0505 B5D2 20 29 B7              JSR   setupformvx              ;set up for mvn/mvp
0506 B5D5 80 14                 BRA   mmdfirst
0507 B5D7
0508 B5D7              ; main move loop
0509 B5D7
0510 B5D7              MMDMORE  EQU   *
0511 B5D7 85 10                 STA   mcount+2                 ; more bytes to move
0512 B5D9 A5 04                 LDA   mdomove+1                ; a = srcdst banks
0513 B5DB E0 01 00              CPX   #$0001                   ; bank cross? if x=0
0514 B5DE B0 03                 BCS   mmdxnot0
0515 B5E0 69 00 01              ADC   #$0100                   ; add 1 to source bank
0516 B5E3
0517 B5E3              MMDXNOT0 EQU   *
0518 B5E3 C0 00 00              CPY   #$0000                   ; did destination cross bank?
0519 B5E6 D0 01                 BNE   mmdyis0
0520 B5E8 1A                    INC   a
0521 B5E9
0522 B5E9              MMDYIS0  EQU   *
0523 B5E9 85 04                 STA   mdomove+1
0524 B5EB
0525 B5EB              MMDFIRST EQU   *
0526 B5EB 8A                    TXA                            ; if count > -x then bank cross
0527 B5EC 49 FF FF              EOR   #$ffff
0528 B5EF C5 07                 CMP   mtempcount
0529 B5F1 B0 02                 BCS   mmdxok
0530 B5F3 85 07                 STA   mtempcount               ; only move -x bytes
0531 B5F5
0532 B5F5              MMDXOK   EQU   *
0533 B5F5 98                    TYA                            ; will destination cross bank?
0534 B5F6 49 FF FF              EOR   #$ffff
0535 B5F9 C5 07                 CMP   mtempcount
0536 B5FB B0 02                 BCS   mmdyok
0537 B5FD 85 07                 STA   mtempcount               ; only move -y bytes
0538 B5FF
0539 B5FF              MMDYOK   EQU   *
0540 B5FF 20 41 B7              JSR   domvxonstack
0541 B602 10 D3                 BPL   mmdmore
0542 B604
0543 B604 4C B1 B5              JMP   mmovefinished
0544 B607
0545 B607              MSCONDCON EQU   *                       ;0 source constant -destination constant
0546 B607
0547 B607              ;move with the source = constant address and the dest = constant address
0548 B607              ; 'y' contains count on entry
0549 B607
0550 B607 A6 10                 LDX   mcount+2                 ;high byte of count in 'x'
0551 B609              ;
0552 B609              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
0553 B609              ; we don't have to reset to 16 bit mode for 'a' here since mmovefinished does
0554 B609              ; it for us.
0555 B609
0556 B609 E2 20                 SEP   #$20                     ;make 'a' register 8 bits
0557 B60B              ;
0558 B60B              MSCONDCONLP EQU   *
0559 B60B A7 16                 LDA   [msource]                ;indirectly get source information
0560 B60D 87 12                 STA   [mdest]                  ; and write it to the dest location
0561 B60F
0562 B60F              ; decrement counter by incrementing it to $00000000
0563 B60F
0564 B60F C8                    INY                            ;increment move counter here
0565 B610 D0 F9                 BNE   mscondconlp              ;loop if didn't drop to zero yet
0566 B612 E8                    INX                            ;increment high byte of move counter
0567 B613 D0 F6                 BNE   mscondconlp              ;loop if done
0568 B615
0569 B615 4C B1 B5              JMP   mmovefinished
0570 B618
0571 B618              MSINCDCON EQU   *                       ;1 source incs - destination constant
0572 B618
0573 B618              ;
0574 B618              ;move with the source = incrementing address and the dest = constant address
0575 B618              ; 'y' contains count on entry
0576 B618
0577 B618 BB                    TYX                            ;low word of count is in 'y' on entry
0578 B619 A0 00 00              LDY   #$0000                   ;start at first source byte
0579 B61C              ;
0580 B61C              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
0581 B61C              ; we don't have to reset to 16 bit mode for 'a' here since mmovefinished does
0582 B61C              ; it for us.
0583 B61C
0584 B61C E2 20                 SEP   #$20                     ;must use 8 bit 'a' register
0585 B61E
0586 B61E              MSINCDCONLP EQU   *
0587 B61E B7 16                 LDA   [msource],y              ;get value to write
0588 B620 87 12                 STA   [mdest]                  ; and write it to constant location
0589 B622
0590 B622              ; set up for new source address
0591 B622
0592 B622 C8                    INY                            ;go to next source location
0593 B623 D0 02                 BNE   msincdconlp2             ;loop if not = 0 yet
0594 B625
0595 B625              ; the next inc is an eight bit increment but that is ok since the high
0596 B625              ; byte of the high word is always zero to start anyway
0597 B625
0598 B625 E6 18                 INC   msource+2                ;increment bank number
0599 B627
0600 B627              ; decrement counter by incrementing it to $00000000
0601 B627
0602 B627              MSINCDCONLP2 EQU   *
0603 B627 E8                    INX                            ;increment to 0
0604 B628 D0 F4                 BNE   msincdconlp              ;loop if not done
0605 B62A
0606 B62A E6 10                 INC   mcount+2                 ;increment low byte of count word
0607 B62C D0 F0                 BNE   msincdconlp              ;not = 0 then just continue
0608 B62E E6 11                 INC   mcount+3                 ;increment upper byte of word too
0609 B630 D0 EC                 BNE   msincdconlp              ;loop if not done
0610 B632
0611 B632 4C B1 B5              JMP   mmovefinished            ;all done so exit
0612 B635
0613 B635              MSDECDCON EQU   *                       ;2 source decs - destination constant
0614 B635
0615 B635
0616 B635              ;move with the source = decrementing address and the dest = constant address
0617 B635              ; 'y' contains count on entry
0618 B635
0619 B635 BB                    TYX                            ;low word of count
0620 B636 A4 16                 LDY   msource                  ;start at first source address
0621 B638 64 16                 STZ   msource                  ;reset source pointer
0622 B63A
0623 B63A              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
0624 B63A              ; we don't have to reset to 16 bit mode for 'a' here since mmovefinished does
0625 B63A              ; it for us.
0626 B63A
0627 B63A E2 20                 SEP   #$20                     ;must use 8 bit 'a' register
0628 B63C
0629 B63C              MSDECDCONLP EQU   *
0630 B63C B7 16                 LDA   [msource],y              ;get next data byte to move
0631 B63E 87 12                 STA   [mdest]                  ;store at constant destination
0632 B640
0633 B640 88                    DEY                            ;decrement to next source location
0634 B641 C0 FF FF              CPY   #$ffff                   ;dec through 0 then adjust source bank
0635 B644 D0 02                 BNE   msdecdconlp2             ;<>= then do some more
0636 B646
0637 B646              ; the next dec is an eight bit decrement but that is ok since the caller
0638 B646              ; should never be decrementing in bank $00 and expect to go into bank $ff.
0639 B646              ;
0640 B646 C6 18                 DEC   msource+2                ;decrement source bank
0641 B648              ;
0642 B648              ; decrement counter by incrementing it to $00000000
0643 B648
0644 B648              MSDECDCONLP2 EQU   *
0645 B648 E8                    INX                            ;adjust counter
0646 B649 D0 F1                 BNE   msdecdconlp              ;<>= then do some more
0647 B64B
0648 B64B E6 10                 INC   mcount+2                 ;increment low byte of count word
0649 B64D D0 ED                 BNE   msdecdconlp              ;not = 0 then just continue
0650 B64F E6 11                 INC   mcount+3                 ;increment upper byte of word too
0651 B651 D0 E9                 BNE   msdecdconlp              ;<>= then do some more
0652 B653
0653 B653 4C B1 B5              JMP   mmovefinished            ;done when we fall to here
0654 B656
0655 B656              MSCONDINC EQU   *                       ;4 source constant - destination incs
0656 B656
0657 B656              ;move with the source = constant address and the dest = incrementing address
0658 B656              ; 'y' contains count on entry
0659 B656
0660 B656 BB                    TYX                            ;low word of count
0661 B657 A0 00 00              LDY   #$0000                   ;start at first destination byte
0662 B65A
0663 B65A              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
0664 B65A              ; we don't have to reset to 16 bit mode for 'a' here since mmovefinished does
0665 B65A              ; it for us.
0666 B65A
0667 B65A E2 20                 SEP   #$20                     ;must use 8 bit 'a' register
0668 B65C              ;
0669 B65C              MSCONDINCLP EQU   *
0670 B65C A7 16                 LDA   [msource]                ;get constant value to write
0671 B65E 97 12                 STA   [mdest],y                ; and write it to incrementing location
0672 B660
0673 B660              ; set up for new source address
0674 B660
0675 B660 C8                    INY                            ;go to next source location
0676 B661 D0 02                 BNE   mscondinclp2             ;loop if not = 0 yet
0677 B663
0678 B663              ; the next inc is an eight bit increment but that is ok since the high
0679 B663              ; byte of the high word is always zero to start anyway
0680 B663
0681 B663 E6 14                 INC   mdest+2                  ;increment bank number
0682 B665              ;
0683 B665              ; decrement counter by incrementing it to $00000000
0684 B665
0685 B665              MSCONDINCLP2 EQU   *
0686 B665 E8                    INX                            ;increment to 0
0687 B666 D0 F4                 BNE   mscondinclp              ;loop if not done
0688 B668
0689 B668 E6 10                 INC   mcount+2                 ;increment low byte of count word
0690 B66A D0 F0                 BNE   mscondinclp              ;not = 0 then just continue
0691 B66C E6 11                 INC   mcount+3                 ;increment upper byte of word too
0692 B66E D0 EC                 BNE   mscondinclp              ;loop if not done
0693 B670
0694 B670 4C B1 B5              JMP   mmovefinished            ;all done so exit
0695 B673
0696 B673              MSDECDINC EQU   *                       ;6 source decs - destination incs
0697 B673
0698 B673              ;move with the source = decrementing address and the dest = incrementing address
0699 B673
0700 B673 A4 16                 LDY   msource                  ;decrementing address
0701 B675 64 16                 STZ   msource                  ;reset source address
0702 B677 A2 00 00              LDX   #$0000                   ;incrementing address
0703 B67A
0704 B67A              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
0705 B67A              ; we don't have to reset to 16 bit mode for 'a' here since mmovefinished does
0706 B67A              ; it for us.
0707 B67A
0708 B67A E2 20                 SEP   #$20                     ;must use 8 bit 'a' register
0709 B67C
0710 B67C              MSDECDINCLP EQU   *
0711 B67C B7 16                 LDA   [msource],y              ;get a byte to transfer
0712 B67E 5A                    PHY                            ;save 'y'
0713 B67F 9B                    TXY                            ;get destination address
0714 B680 97 12                 STA   [mdest],y                ;save the byte
0715 B682 7A                    PLY                            ;restore source index
0716 B683
0717 B683 88                    DEY                            ;next source index
0718 B684 C0 FF FF              CPY   #$ffff                   ;did we fall through 0 ??
0719 B687 D0 02                 BNE   msdecdinclp2             ;if not go here
0720 B689
0721 B689              ; the next dec is an eight bit decrement but that is ok since the caller
0722 B689              ; should never be decrementing in bank $00 and expect to go into bank $ff.
0723 B689
0724 B689 C6 18                 DEC   msource+2                ;back up a bank
0725 B68B
0726 B68B              MSDECDINCLP2 EQU   *
0727 B68B E8                    INX                            ;next destination index
0728 B68C D0 02                 BNE   msdecdinclp4             ;loop if no bank cross
0729 B68E
0730 B68E              ; the next inc is an eight bit increment but that is ok since the high
0731 B68E              ; byte of the high word is always zero to start anyway
0732 B68E
0733 B68E E6 14                 INC   mdest+2                  ;next bank please
0734 B690
0735 B690              ; decrement counter by incrementing it to $00000000
0736 B690
0737 B690              MSDECDINCLP4 EQU   *
0738 B690 E6 0E                 INC   mcount                   ;increment low word of count
0739 B692 D0 E8                 BNE   msdecdinclp
0740 B694 E6 0F                 INC   mcount+1
0741 B696 D0 E4                 BNE   msdecdinclp
0742 B698 E6 10                 INC   mcount+2                 ;increment upper word of count
0743 B69A D0 E0                 BNE   msdecdinclp
0744 B69C E6 11                 INC   mcount+3
0745 B69E D0 DC                 BNE   msdecdinclp              ;loop if not done
0746 B6A0
0747 B6A0 4C B1 B5              JMP   mmovefinished            ;exit via common routines
0748 B6A3
0749 B6A3              MSCONDDEC EQU   *                       ;8 source constant - destination decs
0750 B6A3
0751 B6A3              ;move with the source = constant address and the dest = decrementing address
0752 B6A3              ; 'y' contains count on entry
0753 B6A3
0754 B6A3 BB                    TYX                            ;low word of count
0755 B6A4 A4 12                 LDY   mdest                    ;start at first destination address
0756 B6A6 64 12                 STZ   mdest                    ;reset destination pointer
0757 B6A8
0758 B6A8              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
0759 B6A8              ; we don't have to reset to 16 bit mode for 'a' here since mmovefinished does
0760 B6A8              ; it for us.
0761 B6A8
0762 B6A8 E2 20                 SEP   #$20                     ;must use 8 bit 'a' register
0763 B6AA
0764 B6AA              MSCONDDECLP EQU   *
0765 B6AA A7 16                 LDA   [msource]                ;get constant source byte
0766 B6AC 97 12                 STA   [mdest],y                ;store at decrementing destination
0767 B6AE
0768 B6AE 88                    DEY                            ;decrement to next source location
0769 B6AF C0 FF FF              CPY   #$ffff                   ;dec through 0 then adjust dest bank
0770 B6B2 D0 02                 BNE   msconddeclp2             ;<>= then do some more
0771 B6B4
0772 B6B4              ; the next dec is an eight bit decrement but that is ok since the caller
0773 B6B4              ; should never be decrementing in bank $00 and expect to go into bank $ff.
0774 B6B4
0775 B6B4 C6 14                 DEC   mdest+2                  ;decrement source bank
0776 B6B6
0777 B6B6              ; decrement counter by incrementing it to $00000000
0778 B6B6
0779 B6B6              MSCONDDECLP2 EQU   *
0780 B6B6 E8                    INX                            ;adjust counter
0781 B6B7 D0 F1                 BNE   msconddeclp              ;<>= then do some more
0782 B6B9
0783 B6B9 E6 10                 INC   mcount+2                 ;increment low byte of count word
0784 B6BB D0 ED                 BNE   msconddeclp              ;not = 0 then just continue
0785 B6BD E6 11                 INC   mcount+3                 ;increment upper byte of word too
0786 B6BF D0 E9                 BNE   msconddeclp              ;<>= then do some more
0787 B6C1
0788 B6C1 4C B1 B5              JMP   mmovefinished            ;done when we fall to here
0789 B6C4
0790 B6C4              MSINCDDEC EQU   *                       ;9 source incs - destination decs
0791 B6C4
0792 B6C4              ;move with the source = incrementing address and the dest = decrementing address
0793 B6C4
0794 B6C4 A0 00 00              LDY   #$0000                   ;incrementing address
0795 B6C7 A6 12                 LDX   mdest                    ;decrementing address
0796 B6C9 64 12                 STZ   mdest                    ;reset destination address
0797 B6CB
0798 B6CB              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
0799 B6CB              ; we don't have to reset to 16 bit mode for 'a' here since mmovefinished does
0800 B6CB              ; it for us.
0801 B6CB
0802 B6CB E2 20                 SEP   #$20                     ;must use 8 bit 'a' register
0803 B6CD
0804 B6CD              MSINCDDECLP EQU   *
0805 B6CD B7 16                 LDA   [msource],y              ;get a byte to transfer
0806 B6CF 5A                    PHY                            ;save 'y'
0807 B6D0 9B                    TXY                            ;get destination address
0808 B6D1 97 12                 STA   [mdest],y                ;save the byte
0809 B6D3 7A                    PLY                            ;restore source index
0810 B6D4
0811 B6D4 C8                    INY                            ;next source index
0812 B6D5 D0 02                 BNE   msincddeclp2             ;if not go here
0813 B6D7
0814 B6D7              ; the next inc is an eight bit increment but that is ok since the high
0815 B6D7              ; byte of the high word is always zero to start anyway
0816 B6D7
0817 B6D7 E6 18                 INC   msource+2                ;next bank
0818 B6D9
0819 B6D9              MSINCDDECLP2 EQU   *
0820 B6D9 CA                    DEX                            ;next destination index
0821 B6DA E0 FF FF              CPX   #$ffff                   ;fallen through $0000 yet??
0822 B6DD D0 02                 BNE   msincddeclp4             ;loop if no bank cross
0823 B6DF
0824 B6DF              ; the next dec is an eight bit decrement but that is ok since the caller
0825 B6DF              ; should never be decrementing in bank $00 and expect to go into bank $ff.
0826 B6DF
0827 B6DF C6 14                 DEC   mdest+2                  ;next bank please
0828 B6E1
0829 B6E1              ; decrement counter by incrementing it to $00000000
0830 B6E1
0831 B6E1              MSINCDDECLP4 EQU   *
0832 B6E1 E6 0E                 INC   mcount                   ;increment low word of count
0833 B6E3 D0 E8                 BNE   msincddeclp
0834 B6E5 E6 0F                 INC   mcount+1
0835 B6E7 D0 E4                 BNE   msincddeclp
0836 B6E9 E6 10                 INC   mcount+2                 ;increment upper word of count
0837 B6EB D0 E0                 BNE   msincddeclp
0838 B6ED E6 11                 INC   mcount+3
0839 B6EF D0 DC                 BNE   msincddeclp              ;loop if not done
0840 B6F1
0841 B6F1 4C B1 B5              JMP   mmovefinished            ;exit via common routines
0842 B6F4
0843 B6F4              MSDECDDEC EQU   *                       ;a source decs - destination decs
0844 B6F4
0845 B6F4              ; move with decrementing source address and decrementing destination address
0846 B6F4
0847 B6F4              ; set the move instuction in zero page to mvp
0848 B6F4              ;
0849 B6F4 A9 44 00              LDA   #$0044                   ;mvp instruction
0850 B6F7 85 03                 STA   mdomove                  ;upper byte doesn't matter it's modified
0851 B6F9
0852 B6F9 20 29 B7              JSR   setupformvx              ;set up for mvn/mvp
0853 B6FC 80 15                 BRA   ddmmdfirst
0854 B6FE
0855 B6FE              ; main move loop
0856 B6FE
0857 B6FE              DDMMDMORE EQU   *
0858 B6FE 85 10                 STA   mcount+2                 ; more bytes to move
0859 B700 A5 04                 LDA   mdomove+1                ; 'a' = srcdst banks
0860 B702 E0 FF FF              CPX   #$ffff                   ; bank cross? if x=0
0861 B705 D0 04                 BNE   ddmmdxnot0
0862 B707 38                    SEC   
0863 B708 E9 00 01              SBC   #$0100                   ; subtract 1 to source bank
0864 B70B
0865 B70B              DDMMDXNOT0 EQU   *
0866 B70B C0 FF FF              CPY   #$ffff                   ; did destination cross bank?
0867 B70E D0 01                 BNE   ddmmdyis0
0868 B710 3A                    DEC   a
0869 B711
0870 B711              DDMMDYIS0 EQU   *
0871 B711 85 04                 STA   mdomove+1
0872 B713
0873 B713              DDMMDFIRST EQU   *
0874 B713 8A                    TXA                            ; if count > source then bank cross
0875 B714 C5 07                 CMP   mtempcount
0876 B716 B0 02                 BCS   ddmmdxok
0877 B718 85 07                 STA   mtempcount               ; only move source bytes
0878 B71A
0879 B71A              DDMMDXOK EQU   *
0880 B71A 98                    TYA                            ; will destination cross bank?
0881 B71B C5 07                 CMP   mtempcount
0882 B71D B0 02                 BCS   ddmmdyok
0883 B71F 85 07                 STA   mtempcount               ; only move dest bytes
0884 B721
0885 B721              DDMMDYOK EQU   *
0886 B721 20 41 B7              JSR   domvxonstack
0887 B724 10 D8                 BPL   ddmmdmore
0888 B726
0889 B726 4C B1 B5              JMP   mmovefinished            ;exit via common routines
0890 B729
0891 B729              SETUPFORMVX EQU   *
0892 B729
0893 B729              ; set up the self modifying code to contain destination
0894 B729              ; and source in operand of mvn/mvp instruction constructed on stack.
0895 B729
0896 B729 A5 18                 LDA   msource+2                ;get source bank
0897 B72B EB                    XBA   
0898 B72C 05 14                 ORA   mdest+2                  ;or in destination bank
0899 B72E 85 04                 STA   mdomove+1                ;put bank into mvn/mvp instruction
0900 B730
0901 B730              ; decrement count because it contains actual transfer count whereas
0902 B730              ; remainder of routine assumes it contains transfer count - 1
0903 B730
0904 B730 A5 0E                 LDA   mcount
0905 B732 D0 02                 BNE   mara1
0906 B734 C6 10                 DEC   mcount+2
0907 B736              MARA1    EQU   *
0908 B736 C6 0E                 DEC   mcount
0909 B738
0910 B738              ; a move instuction is already on zero page at this point in the code
0911 B738
0912 B738              ; initialize registers and tempcount for mvn/mvp on stack
0913 B738
0914 B738 A6 16                 LDX   msource                  ; X = low word of source
0915 B73A A4 12                 LDY   mdest                    ; Y = low word of dest
0916 B73C A5 0E                 LDA   mcount
0917 B73E 85 07                 STA   mtempcount
0918 B740 60                    RTS   
0919 B741
0920 B741              DOMVXONSTACK EQU   *
0921 B741
0922 B741              ; set up the address to rtl to which does the mvn on stack
0923 B741              ; this is the equivalent of a self modifying jmp absolute long instruction.
0924 B741
0925 B741 4B                    PHK                            ;push rtl return on stack
0926 B742 F4 51 B7              PEA   mcontdomove-1            ;push rtl return address-1 on stack
0927 B745
0928 B745 F4 00 00              PEA   $0000                    ;we'll leave high byte $00 on stack
0929 B748 AB                    PLB                            ; for setting correct execution bank.
0930 B749 3B                    TSC                            ;where are we now?
0931 B74A 18                    CLC   
0932 B74B 69 09 00              ADC   #$0009                   ;where are we going?
0933 B74E
0934 B74E              ; +2 around user's direct page on stack
0935 B74E              ; +1 around user's data bank on stack
0936 B74E              ; +3 around m_contdomove rtl info on stack
0937 B74E              ; +2 around rts from jsr domvxonstack
0938 B74E              ; +1 around execution bank just put on stk
0939 B74E 48                    PHA                            ;full rtl info on stack
0940 B74F
0941 B74F A5 07                 LDA   mtempcount               ; get the number of bytes to move
0942 B751 6B                    RTL                            ;execute on stack in case we're in rom
0943 B752
0944 B752              MCONTDOMOVE EQU   *                     ;return here after mvn
0945 B752 A5 0E                 LDA   mcount                   ; count = count - bytes moved
0946 B754 18                    CLC                            ; actual bytes moved 1 more than count
0947 B755 E5 07                 SBC   mtempcount
0948 B757 85 0E                 STA   mcount
0949 B759 85 07                 STA   mtempcount
0950 B75B A5 10                 LDA   mcount+2
0951 B75D E9 00 00              SBC   #$0000
0952 B760 60                    RTS   
0953 B761
0954 B761
0955 B761
0956 B761                       TITLE 'Miscellaneous Debug2 Routines'
0957 B761
0958 B761              ******************************************************
0959 B761              *                                                    *
0960 B761              *             Miscellaneous Debug2 Routines          *
0961 B761              *                                                    *
0962 B761              *                    by                              *
0963 B761              *               Fern Bachman     1985-1987           *
0964 B761              *               Joe Bo           1987-1989           *
0965 B761              *                                                    *
0966 B761              *       Copyright Apple Computer, Inc. 1985-1989     *
0967 B761              *                All Rights Reserved.                *
0968 B761              *                                                    *
0969 B761              ******************************************************
0970 B761
0971 B761              XVFY     EQU   *
0972 B761                       LONGA OFF                      	;8 bit land
0973 B761                       LONGI OFF
0974 B761 AF A7 01 E1           LDA   >HIGHBANK                ;CHK for crossing bank
0975 B765 CF 3E 01 E1           CMP   >BANKS                   ;
0976 B769 F0 0C                 BEQ   @0                       ;Bra if not
0977 B76B 90 0A                 BCC   @0                       ;Bra if EXTENDBNKS < BANKS    
0978 B76D A5 3F                 LDA   A2H                      ;Cross bank, temp store A2 
0979 B76F 48                    PHA                            ; and temp set to $ffff of that bank
0980 B770 48                    PHA   
0981 B771 A9 FF                 LDA   #$FF
0982 B773 85 3F                 STA   A2H
0983 B775 85 3E                 STA   A2L
0984 B777              @0       EQU   *
0985 B777 20 E7 B7              JSR   READBYT1                 ;VERIFY (A1) THRU (A2)
0986 B77A 48                    PHA   
0987 B77B A2 42                 LDX   #A4L
0988 B77D 20 E9 B7              JSR   READBYTE
0989 B780 85 40                 STA   A3L
0990 B782 68                    PLA   
0991 B783 C5 40                 CMP   A3L
0992 B785 F0 1A                 BEQ   @1
0993 B787 48                    PHA   
0994 B788 20 7A A9              JSR   PRADDR
0995 B78B 68                    PLA   
0996 B78C 20 A3 A9              JSR   PRBYTEFF
0997 B78F 20 91 AC              JSR   PR1BLNKFF
0998 B792 A9 A8                 LDA   #$A8
0999 B794 20 D1 A9              JSR   COUTFF
1000 B797 A5 40                 LDA   A3L
1001 B799 20 A3 A9              JSR   PRBYTEFF
1002 B79C A9 A9                 LDA   #$A9
1003 B79E 20 D1 A9              JSR   COUTFF
1004 B7A1              @1       EQU   *
1005 B7A1 20 B4 FC              JSR   NXTA4
1006 B7A4 08                    PHP                            ;Save the returned 'c'
1007 B7A5 A5 43                 LDA   A4H                      ;CHK destination bank (A4) at bank boundary or not ?
1008 B7A7 05 42                 ORA   A4L
1009 B7A9 D0 09                 BNE   @00                      ;Bra if not
1010 B7AB AF 3F 01 E1           LDA   >BANKD                   ;Else need to increase source bank
1011 B7AF 1A                    INC   A
1012 B7B0 8F 3F 01 E1           STA   >BANKD                   ;?? NO INC =BANKD
1013 B7B4              @00      EQU   *
1014 B7B4 28                    PLP                            ;Get 'c'
1015 B7B5 90 C0                 BCC   @0                       ;Bra if source address not yet hit its high address
1016 B7B7              @3       EQU   *
1017 B7B7 AF 3E 01 E1           LDA   >BANKS                   ;CHK if source bank already passer bank $ff
1018 B7BB 1A                    INC   A
1019 B7BC 48                    PHA                            ;Temp save
1020 B7BD F0 26                 BEQ   @4                       ;Bra if previous one is $ff
1021 B7BF CF A7 01 E1           CMP   >HIGHBANK                ;Compare for source ending bank
1022 B7C3 F0 13                 BEQ   @5                       ;Bra if source start bank = end bank, prepare to exit 
1023 B7C5 B0 1E                 BCS   @4                       ;If already greater than, then exit
1024 B7C7 68                    PLA   
1025 B7C8 8F 3E 01 E1           STA   >BANKS                   ;Store as new source start bank
1026 B7CC 64 3D                 STZ   A1H                      ;Set new bank starting address to $0000
1027 B7CE 64 3C                 STZ   A1L
1028 B7D0 A9 FF                 LDA   #$FF                     ;And ending address to $ffff
1029 B7D2 85 3F                 STA   A2H
1030 B7D4 85 3E                 STA   A2L
1031 B7D6 80 9F                 BRA   @0                       ;Bra to continue on
1032 B7D8              @5       EQU   *
1033 B7D8 68                    PLA                            ;Get back new bank
1034 B7D9 8F 3E 01 E1           STA   >BANKS
1035 B7DD 68                    PLA                            ;Get back the user's high address, A2H
1036 B7DE 85 3E                 STA   A2L
1037 B7E0 68                    PLA   
1038 B7E1 85 3F                 STA   A2H
1039 B7E3 80 92                 BRA   @0                       ;Bra to continue for partial bank
1040 B7E5              @4       EQU   *
1041 B7E5 68                    PLA                            ;Clean stack and exit
1042 B7E6 60                    RTS   
1043 B7E7
1044 B7E7
1045 B7E7              *
1046 B7E7              READBYT1 EQU   *
1047 B7E7 A2 3C                 LDX   #A1L                     ;read from bank 1
1048 B7E9              READBYTE EQU   *
1049 B7E9 B8                    CLV                            ;V clear for read
1050 B7EA 50 02                 BVC   MEMACC1
1051 B7EC              STORBYTE EQU   *
1052 B7EC E2 40                 SEP   #$40                     ;V set for write
1053 B7EE              MEMACC1  EQU   *
1054 B7EE EB                    XBA                            ;Save 'A' in 'B'
1055 B7EF AD 68 C0              LDA   STATEREG                 ;Save memory state
1056 B7F2 CD 83 C0              CMP   LCBANK2                  ;[Write enable the language card always]
1057 B7F5 CD 83 C0              CMP   LCBANK2                  ;[Write enable the language card always]
1058 B7F8 48                    PHA                            ;
1059 B7F9 8B                    PHB                            ;Save data bank register
1060 B7FA 29 F2                 AND   #$F2                     ;Enable slot LCRAM/BANK1/SLOTCxROM to read
1061 B7FC 48                    PHA                            ;Save 'A'
1062 B7FD AF 2F 01 E1           LDA   >LVAL                    ;Check which LC bank to enable
1063 B801 0A                    ASL   A                        ;Bit 2=1 for bank1 else leave bank0
1064 B802 0A                    ASL   A                        ;
1065 B803 03 01                 ORA   1,S                      ;Or in status byte on stack
1066 B805 83 01                 STA   1,S                      ;Save new memory configuration
1067 B807 AF 8F 01 E1           LDA   >ORGMEMORY               ; and test for special mem configuration.
1068 B80B F0 06                 BEQ   @1                       ;ORGMEMORY=0 then use normal mem config.
1069 B80D AF 2D 01 E1           LDA   >MVAL                    ;Special memory configuration is here
1070 B811 83 01                 STA   1,S                      ; else use BRK/unknown COP mem config.
1071 B813              @1       EQU   *
1072 B813 68                    PLA                            ;Recall memory configuration to use.
1073 B814 8D 68 C0              STA   STATEREG                 ; by changing state reg.
1074 B817 E0 42                 CPX   #A4L                     ;Use src bnk for A1,A2,A3, dest bnk for A4
1075 B819 90 06                 BCC   @11                      ;
1076 B81B AF 3F 01 E1           LDA   >BANKD                   ;What's destination bank?
1077 B81F B0 04                 BCS   @2                       ;
1078 B821              @11      EQU   *
1079 B821 AF 3E 01 E1           LDA   >BANKS                   ;What's source bank?
1080 B825              @2       EQU   *
1081 B825 48                    PHA                            ;Move Bank to data bank register
1082 B826 AB                    PLB                            ; for reading/writing of data.
1083 B827 EB                    XBA                            ;Recall 'A' in case we're storing it
1084 B828 50 04                 BVC   @22                      ;
1085 B82A 81 00                 STA   (0,X)                    ;Else store to correct bank and address
1086 B82C 80 02                 BRA   MEMEXIT                  ;Exit by restoring to original state
1087 B82E
1088 B82E              @22      EQU   *
1089 B82E A1 00                 LDA   (0,X)                    ;Read value for user/keep in 'A' for user
1090 B830
1091 B830              MEMEXIT  EQU   *
1092 B830 EB                    XBA                            ;Preserve 'A' in 'B'
1093 B831 AB                    PLB                            ;Restore correct data bank register
1094 B832 68                    PLA                            ;Restore memory state
1095 B833              MEMEXIT1 EQU   *
1096 B833 29 BF                 AND   #$BF                     ;Fix page 2 switch in case user changed it
1097 B835 2C 1C C0              BIT   RDPAGE2                  ;- if page 2 is on
1098 B838 10 02                 BPL   @1                       ;+ if page 1 is on
1099 B83A 09 40                 ORA   #$40                     ;Page 2 on then set bit
1100 B83C              @1       EQU   *
1101 B83C 8D 68 C0              STA   STATEREG                 ;
1102 B83F EB                    XBA                            ;Back to caller with 'A' correct
1103 B840 60                    RTS                            ;
1104 B841                       EJECT 
1105 B841              * Pattern search is done in 2 steps.
1106 B841              * 1. Set up the pattern to search for in the input buffer
1107 B841              *    preceeded by the # of bytes in the pattern in location $200.
1108 B841              * 2. Do the actual pattern search after the user types in
1109 B841              *    the range to search and a 'P'.
1110 B841              *
1111 B841              * Pattern search format is as follows
1112 B841              * \ xx yy zz "12345" 'abcd' aa bb cc \<bb1/addr.bb2/addr2P
1113 B841              * If high bank is not specified then EQUALS starting bank
1114 B841              *
1115 B841              * '\' starts and '\' terminates set pattern routine normally.
1116 B841              * $8D terminates the entire line and reenters the monitor.
1117 B841
1118 B841              SETPTRN  EQU   *
1119 B841 AD 00 02              LDA   IN                       ;Test if been here before
1120 B844 F0 1D                 BEQ   @1                       ;If been here before skip setup
1121 B846 AF 3E 01 E1           LDA   >BANKS                   ;Save the usr's bank
1122 B84A 8F 8D 01 E1           STA   >STEPSP+1                ;Safe to store here
1123 B84E 8B                    PHB                            ;Change source bank to data bank register
1124 B84F 68                    PLA                            ;
1125 B850 8F 3E 01 E1           STA   >BANKS                   ;
1126 B854 9C 00 02              STZ   IN                       ;Reset # of bytes in pattern to search for
1127 B857 A9 BA                 LDA   #$BA                     ;Get into store mode
1128 B859 85 31                 STA   MONMODE                  ;
1129 B85B A9 02                 LDA   #$02                     ;Set PCL/PCH to $0201
1130 B85D 85 41                 STA   A3H                      ;Will become new PCH
1131 B85F 3A                    DEC   A                        ;
1132 B860 85 40                 STA   A3L                      ;Will become new PCL
1133 B862 60                    RTS                            ;Back to caller
1134 B863
1135 B863              @1       EQU   *
1136 B863 AF 42 01 E1           LDA   >DIGITCNT                ;If anything entered then store it
1137 B867 F0 03                 BEQ   @2                       ;=0 then just continue normally
1138 B869 20 C6 B2              JSR   XSTOR                    ;Store entered HEX value
1139 B86C              @2       EQU   *
1140 B86C A5 3A                 LDA   PCL                      ;Calculate # of bytes in pattern
1141 B86E 3A                    DEC   A                        ;Ending point -1 = # of bytes in pattern
1142 B86F 8D 00 02              STA   IN                       ;Save result for later
1143 B872 AF 8D 01 E1           LDA   >STEPSP+1                ;Restore usr's bank
1144 B876 8F 3E 01 E1           STA   >BANKS                   ;Used in 'XSEARCH'
1145 B87A 60                    RTS                            ;Back to caller
1146 B87B
1147 B87B
1148 B87B              XSEARCH  EQU   *
1149 B87B C2 20                 REP   #$20                     ;Off to 16 bit land
1150 B87D                       LONGA ON
1151 B87D A5 3E                 LDA   A2L                      ;Save high address in case
1152 B87F 48                    PHA                            ; cross bank required
1153 B880 E2 20                 SEP   #$20                     ;Back to 8 bit land
1154 B882                       LONGA OFF
1155 B882 AF A7 01 E1           LDA   >HIGHBANK                ;Chk for crossing bank
1156 B886 CF 3E 01 E1           CMP   >BANKS
1157 B88A F0 08                 BEQ   @00                      ;Bra if not
1158 B88C 90 06                 BCC   @00                      ;Bra if not
1159 B88E A9 FF                 LDA   #$FF                     ;Else need to adjust high address 
1160 B890 85 3E                 STA   A2L                      ; to $ffff of that bank
1161 B892 85 3F                 STA   A2H
1162 B894              @00      EQU   *
1163 B894 A5 3C                 LDA   A1L                      ;Save low address (pointer) in case
1164 B896 48                    PHA                            ; pattern doesn't all match
1165 B897 A5 3D                 LDA   A1H
1166 B899 48                    PHA   
1167 B89A A0 01                 LDY   #$01                     ;1st byte to chk is 2nd byte in input buff
1168 B89C              @1       EQU   *
1169 B89C 20 E7 B7              JSR   READBYT1                 ;Read byte from memory
1170 B89F D9 00 02              CMP   IN,Y                     ;Test against value in input buffer
1171 B8A2 D0 29                 BNE   @3                       ;
1172 B8A4 20 BA FC              JSR   NXTA1                    ;Inc zero page pointers for next byte
1173 B8A7 B0 35                 BCS   @4                       ;'c' = 1 when done
1174 B8A9              @7       EQU   *
1175 B8A9 C8                    INY                            ;Next byte to test in input buffer
1176 B8AA CC 00 02              CPY   IN                       ;Test against max number to test
1177 B8AD 90 ED                 BCC   @1                       ;Loop if not all there yet
1178 B8AF F0 EB                 BEQ   @1                       ;
1179 B8B1 68                    PLA                            ;Clean up stack
1180 B8B2 68                    PLA                            ;
1181 B8B3 A5 3D                 LDA   A1H                      ;Save pointer on stack
1182 B8B5 48                    PHA                            ;
1183 B8B6 A5 3C                 LDA   A1L                      ;Fix zero page pointer for PRADDR
1184 B8B8 48                    PHA                            ;
1185 B8B9 ED 00 02              SBC   IN                       ;Offset by # of bytes tested
1186 B8BC 85 3C                 STA   A1L                      ;Save for PRADDR
1187 B8BE B0 02                 BCS   @2                       ;No borrow then continue
1188 B8C0 C6 3D                 DEC   A1H                      ;Borrow then dec high byte
1189 B8C2              @2       EQU   *
1190 B8C2 20 7A A9              JSR   PRADDR                   ;Print address
1191 B8C5 68                    PLA                            ;Restore pointer
1192 B8C6 85 3C                 STA   A1L                      ;
1193 B8C8 68                    PLA                            ;
1194 B8C9 85 3D                 STA   A1H                      ;
1195 B8CB 80 C7        @8       BRA   @00                      ;Go look for another match
1196 B8CD
1197 B8CD              @3       EQU   *
1198 B8CD 68                    PLA                            ;Restore pointers into search range
1199 B8CE 85 3D                 STA   A1H                      ;
1200 B8D0 68                    PLA                            ;
1201 B8D1 85 3C                 STA   A1L                      ;
1202 B8D3 20 BA FC              JSR   NXTA1                    ;Try next location
1203 B8D6 90 F3                 BCC   @8                       ;Bra if not up to high address of the bank
1204 B8D8 A5 3C                 LDA   A1L                      ;Make as same stack structure
1205 B8DA 48                    PHA   
1206 B8DB A5 3D                 LDA   A1H
1207 B8DD 48                    PHA   
1208 B8DE
1209 B8DE              @4       EQU   *
1210 B8DE 8B                    PHB                            ;Save data bank register
1211 B8DF 20 82 F8              JSR   DBTOE1                   ;Change to $e1
1212 B8E2 EE 3E 01              INC   |BANKS                   ;INC start bank
1213 B8E5 AF 3E 01 E1           LDA   BANKS
1214 B8E9 F0 20                 BEQ   @5                       ;BRA if previous is $ff 
1215 B8EB CF A7 01 E1           CMP   HIGHBANK                 ;Compare with ending bank
1216 B8EF F0 0F                 BEQ   @6                       ;BRA if start bank = end bank
1217 B8F1 B0 18                 BCS   @5                       ;BRA if start bank > end bank, exit
1218 B8F3 AB                    PLB                            ;Restore bank
1219 B8F4 64 3C                 STZ   A1L                      ;Reset pointer to $00 for new bank
1220 B8F6 64 3D                 STZ   A1H                      ;
1221 B8F8 A9 FF                 LDA   #$FF                     ;Set to $ffff of that bank  
1222 B8FA 85 3F                 STA   A2H
1223 B8FC 85 3E                 STA   A2L
1224 B8FE 80 9C                 BRA   @1                       ;Continue on..
1225 B900              @6       EQU   *
1226 B900 AB                    PLB                            ;
1227 B901 A3 04                 LDA   4,S                      ;Get back user's high address
1228 B903 85 3F                 STA   A2H
1229 B905 A3 03                 LDA   3,S
1230 B907 85 3E                 STA   A2L
1231 B909 80 91                 BRA   @1                       ;Continue on...
1232 B90B              @5       EQU   *                        ;Prepare to end 
1233 B90B CE 3E 01              DEC   |BANKS                   ;Stay to its last bank
1234 B90E AB                    PLB   
1235 B90F C2 20                 REP   #$20
1236 B911 68                    PLA                            ;Clean stack, A2H/A2L 
1237 B912 68                    PLA                            ;Clean stack, A1H/A1l
1238 B913 E2 20                 SEP   #$20
1239 B915
1240 B915 60                    RTS   
1241 B916
1242 B916
